from sklearn.model_selection import RandomizedSearchCV, KFold
from sklearn.gaussian_process import GaussianProcessClassifier
from sklearn.gaussian_process.kernels import RBF, Matern
from sklearn.metrics import accuracy_score, make_scorer
from pathlib import Path

def write_hpValues(model_Name, HP_Values,dataset):
    Path("results/%s" % dataset).mkdir(parents=True, exist_ok=True)
    Path("results/%s/%s" % (dataset,model_Name)).mkdir(parents=True, exist_ok=True)
    file_name = r'results/%s/%s/BestParam.txt' % (dataset,model_Name)
    with open(file_name, 'a+') as x_file:
        x_file.write(str(HP_Values))
        x_file.write("\n----------------------------------------------------------")
    return 0



# parameters grid to select the best combination using the listed values
def GaussianProcess_hyperparameterTuning(X_train, Y_train, dataset):
    grid_Param={'kernel': [1.0*RBF(1.0), 1.0*Matern(1.0)]}
    kfold = KFold(n_splits=5, shuffle=True, random_state=42)

    kernel = 1.0 * RBF(1.0)
    GaussianProcess = GaussianProcessClassifier()
    grid_search = RandomizedSearchCV(estimator= GaussianProcess, param_distributions=grid_Param, n_iter=100, cv=kfold, verbose=2, random_state=42 , scoring='accuracy',error_score=0, n_jobs=3)
    grid_search.fit(X_train, Y_train)
    best_grid = grid_search.best_estimator_
    write_hpValues('GaussianProcess', str(best_grid), dataset)

    print(grid_search.best_estimator_)
    return grid_search


def GaussianProcess_training_tuning(X_train,Y_train,dataset):

    grid = 0
    write_hpValues('GaussianProcess', grid, dataset)
    kernel = 1.0 * RBF(1.0)
    Trained_model = GaussianProcessClassifier(kernel=kernel,random_state = 0)
    Trained_model=Trained_model.fit(X_train,Y_train)
    return Trained_model
